// Frontend with API auto-detect + 15-minute increments
const $ = (s, el=document)=>el.querySelector(s);
const $$ = (s, el=document)=>Array.from(el.querySelectorAll(s));
const rid = () => Math.random().toString(36).slice(2);
const todayISO = () => new Date().toISOString().slice(0,10);
const toMinutes = h => Math.max(0, Math.round(Number(h)*60));
const round15 = h => { const m = toMinutes(h); return Math.max(0, Math.round(m/15)*15)/60; };
const fmtHM = h => { const m = toMinutes(h); const H=Math.floor(m/60), M=m%60; return H?`${H}h ${M?M+'m':''}`.trim():`${M}m`; };

const api = {
  enabled: false,
  async ping(){ try{ const r = await fetch('/api/ping'); this.enabled = r.ok; } catch { this.enabled = false; } return this.enabled; },
  async get(path){ const r = await fetch('/api'+path); if(!r.ok) throw new Error('api'); return r.json(); },
  async post(path, body){ const r = await fetch('/api'+path, {method:'POST', headers:{'Content-Type':'application/json'}, body:JSON.stringify(body)}); if(!r.ok) throw new Error('api'); return r.json(); },
  async del(path){ const r = await fetch('/api'+path, {method:'DELETE'}); if(!r.ok) throw new Error('api'); return r.json(); },
};

// Tabs
$$('.tab-btn').forEach(btn=>btn.addEventListener('click',()=>{
  $$('.tab-btn').forEach(b=>b.dataset.active=false);
  $$('.tab-panel').forEach(p=>p.classList.add('hidden'));
  btn.dataset.active = true;
  document.getElementById(btn.dataset.tab).classList.remove('hidden');
}));
document.querySelector('.tab-btn[data-tab="scarlett"]').dataset.active = true;

// Scarlett
const LS_REVIEWS = 'scarlett_reviews_v3';
const initialReviews = [
  { id: rid(), title: "A Wizard’s Awakening", author: "I. Nightingale", genre: "fantasy", rating: 5, blurb: "A glowing quest about bravery and biscuits."},
  { id: rid(), title: "Moon Library", author: "S. Vale", genre: "fantasy", rating: 4, blurb: "Every book opens a door—some to dragons, some to snacks."},
  { id: rid(), title: "Glimmer City Ghosts", author: "T. Willow", genre: "paranormal", rating: 3, blurb: "Spooky fun with kind ghosts who love board games."},
];
let reviews = [];
function lsGet(k, fb){ try{ const v = JSON.parse(localStorage.getItem(k)); return v ?? fb; } catch { return fb; } }
function lsSet(k, v){ try{ localStorage.setItem(k, JSON.stringify(v)); } catch {} }
async function loadReviews(){ if(api.enabled){ try{ reviews = await api.get('/reviews'); return; } catch{} } reviews = lsGet(LS_REVIEWS, initialReviews); }
async function saveReview(r){ if(api.enabled){ try{ await api.post('/reviews', r); } catch{} } reviews = [r, ...reviews]; lsSet(LS_REVIEWS, reviews); }
function stars(n){ return "★".repeat(n) + "☆".repeat(5-n); }
function renderGenreFilter(){ const sel = $('#genreFilter'); const genres = ['all', ...Array.from(new Set(reviews.map(r=>r.genre)))]; sel.innerHTML = genres.map(g=>`<option value="${g}">${g}</option>`).join(''); }
function renderReviews(){ const grid = $('#reviewsGrid'); grid.innerHTML = ''; const q = ($('#srch').value||'').toLowerCase(); const gf = $('#genreFilter').value; reviews.filter(r => (`${r.title} ${r.author} ${r.blurb}`.toLowerCase().includes(q)) && (gf==='all' || r.genre===gf)).forEach(r => { const card = document.createElement('div'); card.className = "rounded-xl glass h-full"; card.innerHTML = `<div class="p-4 border-b border-white/20 flex justify-between items-start gap-3"><div><div class="font-semibold">${r.title}</div><div class="text-white/90 text-sm">by ${r.author}</div></div><span class="text-xs px-2 py-1 rounded-full chip bg-white text-slate-900">${r.genre}</span></div><div class="p-4 space-y-2"><div class="text-yellow-300">${stars(r.rating)}</div><p class="text-white/90 text-sm">${r.blurb}</p></div>`; grid.appendChild(card); }); }
$('#reviewForm').addEventListener('submit', async e => { e.preventDefault(); const fd = new FormData(e.target); const r = { id: rid(), title: String(fd.get('title')||'').trim(), author: String(fd.get('author')||'Unknown').trim(), blurb: String(fd.get('blurb')||'').trim(), genre: String(fd.get('genre')||'fantasy'), rating: Number(fd.get('rating')||4), }; if(!r.title) return; await saveReview(r); renderGenreFilter(); renderReviews(); e.target.reset(); });
$('#srch').addEventListener('input', renderReviews);
$('#genreFilter').addEventListener('change', renderReviews);

// Felix practice (15‑minute increments)
const LS_PRACTICE = 'felix_practice_v5';
let practice = [];
function parseW(label){ const m=/^W(\d+)$/i.exec(String(label||'').trim()); return m?Number(m[1]):null; }
function nextWeekLabel(){ const nums=practice.map(p=>parseW(p.week)).filter(n=>n!=null); const max=nums.length?Math.max(...nums):0; return 'W'+(max+1); }
async function loadPractice(){ if(api.enabled){ try{ practice = await api.get('/practice'); return; } catch{} } practice = lsGet(LS_PRACTICE, [{ id: rid(), week:"W1", hours: 1.75 },{ id: rid(), week:"W2", hours: 2.5 },{ id: rid(), week:"W3", hours: 1.25 },{ id: rid(), week:"W4", hours: 3.0 }]); }
async function persistPractice(){ lsSet(LS_PRACTICE, practice); }
function renderPracticeSelect(){ const sel = $('#practiceSelect'); const cur = sel.value; sel.innerHTML = practice.map(p=>`<option value="${p.id}">${p.week}</option>`).join(''); if(cur && practice.some(p=>p.id===cur)) sel.value = cur; else if(practice[0]) sel.value = practice[0].id; updateHoursBadge(); drawPracticeChart(); }
function getSelectedWeek(){ const id=$('#practiceSelect').value; return practice.find(p=>p.id===id); }
function updateHoursBadge(){ const p=getSelectedWeek(); $('#currentHours').textContent = p? fmtHM(p.hours) : '0m'; }
$('#practiceForm').addEventListener('submit', async e => { e.preventDefault(); const fd = new FormData(e.target); const item = { id: rid(), week: String(fd.get('week')||'').trim(), hours: round15(Number(fd.get('hours')||0)) }; if(!item.week) return; if(api.enabled){ try{ await api.post('/practice', item); } catch{} } practice.push(item); await persistPractice(); renderPracticeSelect(); $('#practiceSelect').value=item.id; updateHoursBadge(); e.target.reset(); });
async function adjustSelectedMinutes(delta){ const sel=$('#practiceSelect'); const idx=practice.findIndex(p=>p.id===sel.value); if(idx===-1) return; const updated = { ...practice[idx], hours: round15(practice[idx].hours + delta/60) }; practice[idx] = updated; if(api.enabled){ try{ await api.post('/practice', updated); } catch{} } await persistPractice(); renderPracticeSelect(); sel.value = practice[idx]?.id || practice[idx-1]?.id || ''; updateHoursBadge(); }
async function deleteSelectedWeek(){ const sel=$('#practiceSelect'); const id=sel.value; if(api.enabled){ try{ await api.del('/practice/'+encodeURIComponent(id)); } catch{} } practice = practice.filter(p=>p.id!==id); await persistPractice(); renderPracticeSelect(); }
async function addNextWeek(){ const item={ id: rid(), week: nextWeekLabel(), hours: 0 }; if(api.enabled){ try{ await api.post('/practice', item); } catch{} } practice.push(item); await persistPractice(); renderPracticeSelect(); $('#practiceSelect').value=item.id; updateHoursBadge(); }
$('#minus15').addEventListener('click',()=>adjustSelectedMinutes(-15));
$('#plus15').addEventListener('click',()=>adjustSelectedMinutes(15));
$('#plus30').addEventListener('click',()=>adjustSelectedMinutes(30));
$('#deleteWeek').addEventListener('click',deleteSelectedWeek);
$('#nextWeek').addEventListener('click',addNextWeek);

// Chart
let practiceChart=null;
function drawPracticeChart(){ const ctx = $('#practiceChart'); if(!ctx) return; const labels = practice.map(p=>p.week); const data = practice.map(p=>Math.round(p.hours*60)); if(practiceChart) practiceChart.destroy(); practiceChart = new Chart(ctx, { type: 'bar', data: { labels, datasets: [{ label: 'Minutes', data, borderRadius:8, backgroundColor:['#fde047','#34d399','#60a5fa','#f472b6','#fb923c','#a78bfa','#fca5a5','#2dd4bf'] }]}, options: { plugins:{ legend:{ display:false } }, scales:{ x:{ grid:{ display:false } }, y:{ beginAtZero:true } } } }); }

// Notes
const LS_NOTES = 'felix_notes_v3';
let felixNotes = [];
async function loadNotes(){ if(api.enabled){ try{ felixNotes = await api.get('/notes'); return;}catch{} } felixNotes = lsGet(LS_NOTES, []); }
async function saveNote(n){ if(api.enabled){ try{ await api.post('/notes', n);}catch{} } felixNotes=[n,...felixNotes]; lsSet(LS_NOTES, felixNotes); }
function renderFelixNotes(){ const ul=$('#felixNotes'); ul.innerHTML = felixNotes.map(n=>`<li class="rounded-lg chip p-2 text-slate-900 bg-white"><span class="text-xs">${n.date}</span><div>${n.text}</div></li>`).join(''); }
$('#felixNoteForm').addEventListener('submit', async e=>{ e.preventDefault(); const fd=new FormData(e.target); const n={ id:rid(), date:new Date().toLocaleDateString(), text:String(fd.get('text')||'').trim() }; if(!n.text) return; await saveNote(n); renderFelixNotes(); e.target.reset(); });

// Coach notes
const SKILLS=['Forehand','Backhand','Serve','Volleys','Footwork'];
const LS_COACH='coach_notes_v3';
let coachNotes=[];
async function loadCoach(){ if(api.enabled){ try{ coachNotes = await api.get('/coach'); return;}catch{} } coachNotes = lsGet(LS_COACH, []); }
function saveCoachLS(){ lsSet(LS_COACH, coachNotes); }
function renderCoach(){ const ul=$('#coachHistory'); ul.innerHTML = coachNotes.map(n=>`<li class="rounded-lg chip p-2 text-slate-900 bg-white"><div class="text-xs">${n.date}</div><div class="mt-1">${(n.tags||[]).map(t=>`<span class='text-xs px-2 py-0.5 rounded-full bg-yellow-200 mr-1'>${t}</span>`).join('')}</div>${n.text?`<div class='mt-1'>${n.text}</div>`:''}</li>`).join(''); }
const skillButtonsDiv = $('#skillButtons'); const selected = new Set();
SKILLS.forEach(s=>{ const b=document.createElement('button'); b.type='button'; b.className='h-10 rounded-lg chip px-3 text-slate-900'; b.textContent=s; b.addEventListener('click',()=>{ if(selected.has(s)) selected.delete(s); else selected.add(s); b.classList.toggle('bg-yellow-300'); }); skillButtonsDiv.appendChild(b); });
$('#coachDate').value = todayISO();
$('#coachForm').addEventListener('submit', async e=>{ e.preventDefault(); const fd=new FormData(e.target); const note={ id:rid(), date:String(fd.get('date')||todayISO()), text:String(fd.get('text')||'').trim(), tags:[...selected] }; if(!note.text && note.tags.length===0) return; if(api.enabled){ try{ await api.post('/coach', note);}catch{} } coachNotes=[note,...coachNotes]; saveCoachLS(); selected.clear(); $$('#skillButtons button').forEach(b=>b.classList.remove('bg-yellow-300')); e.target.reset(); $('#coachDate').value=todayISO(); renderCoach(); });

// Init
(async function init(){
  await api.ping();
  await loadReviews(); renderGenreFilter(); renderReviews();
  await loadPractice(); renderPracticeSelect();
  await loadNotes(); renderFelixNotes();
  await loadCoach(); renderCoach();
  document.querySelector('.tab-btn[data-tab="scarlett"]').click();
})();
